/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.browser;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.browser.Messages;
import com.aptana.portal.ui.dispatch.BrowserNotifier;
import com.aptana.portal.ui.dispatch.browserFunctions.DispatcherBrowserFunction;
import com.aptana.portal.ui.internal.BrowserFunctionWrapper;
import com.aptana.portal.ui.internal.BrowserViewerWrapper;
import com.aptana.portal.ui.internal.BrowserWrapper;
import com.aptana.ui.dialogs.HyperlinkMessageDialog;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractPortalBrowserEditor
extends EditorPart {
    private static final String BROWSER_DOCS = "http://go.appcelerator.com/troubleshooting_linux";
    private static final String BROWSER_SWT = "swt";
    private static final String BROWSER_CHROMIUM = "chromium";
    private BrowserViewerWrapper browserViewer;
    private BrowserWrapper browser;
    private List<BrowserFunctionWrapper> browserFunctions;
    private String initialURL;
    private boolean disposed;

    public void setURL(URL url) {
        if (url != null) {
            this.browser.setUrl(url.toString());
        } else {
            IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (String)"Ignoring a null URL that was passed to the Aptana Portal");
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        if (this.browser != null) {
            this.browser.addDisposeListener(listener);
        }
    }

    public void createPartControl(Composite parent) {
        try {
            this.browserViewer = AbstractPortalBrowserEditor.createBrowserViewer(parent);
            final Browser browserControl = (Browser)this.browserViewer.getBrowser();
            this.browser = new BrowserWrapper(browserControl);
            browserControl.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    Browser newBrowser = event.browser;
                    final BrowserViewer browserContainer = new BrowserViewer((Composite)browserControl.getShell(), browserControl.getStyle());
                    event.browser = browserContainer.getBrowser();
                    newBrowser.getShell().close();
                    event.required = true;
                    if (newBrowser != browserControl) {
                        LocationAdapter locationAdapter = new LocationAdapter(){

                            public void changing(LocationEvent event) {
                                String url = event.location;
                                if (!StringUtil.isEmpty((String)url)) {
                                    WorkbenchBrowserUtil.openURL((String)url);
                                }
                                browserContainer.getBrowser().removeLocationListener((LocationListener)this);
                            }
                        };
                        browserContainer.getBrowser().addLocationListener((LocationListener)locationAdapter);
                    }
                }
            });
            this.browser.setJavascriptEnabled(true);
            this.browser.addTitleListener(new PortalTitleListener());
            this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){

                public void completed(ProgressEvent event) {
                    AbstractPortalBrowserEditor.this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                        public void changed(LocationEvent event) {
                            AbstractPortalBrowserEditor.this.refreshBrowserRegistration();
                        }
                    });
                }
            });
            this.browser.setUrl(this.initialURL);
            BrowserNotifier.getInstance().registerBrowser(this.getSite().getId(), this.browser);
        }
        catch (Throwable e) {
            HyperlinkMessageDialog dialog = new HyperlinkMessageDialog(UIUtils.getActiveShell(), Messages.AbstractPortalBrowserEditor_ErrorTitle, null, Messages.AbstractPortalBrowserEditor_ErrorMsg, 1, new String[]{IDialogConstants.OK_LABEL}, 0, null){

                protected void openLink(SelectionEvent e) {
                    WorkbenchBrowserUtil.launchExternalBrowser((String)AbstractPortalBrowserEditor.BROWSER_DOCS);
                }
            };
            dialog.open();
        }
    }

    private static BrowserViewerWrapper createBrowserViewer(Composite parent) {
        String browserType = AbstractPortalBrowserEditor.getConfiguredBrowserType();
        if (BROWSER_CHROMIUM.equals(browserType)) {
            return BrowserViewerWrapper.createWebkitBrowserViewer(parent, 0);
        }
        return BrowserViewerWrapper.createSWTBrowserViewer(parent, 0);
    }

    private static String getConfiguredBrowserType() {
        String browserType = EclipseUtil.getSystemProperty((String)"studio.portalBrowser");
        if (BROWSER_CHROMIUM.equals(browserType) && !AbstractPortalBrowserEditor.isChromiumWebkitSupported()) {
            browserType = BROWSER_SWT;
        } else if (browserType == null && AbstractPortalBrowserEditor.isChromiumWebkitSupported()) {
            browserType = BROWSER_CHROMIUM;
        }
        return browserType;
    }

    private static boolean isChromiumWebkitSupported() {
        if ("x86".equals(Platform.getOSArch())) {
            return false;
        }
        if ("x86_64".equals(Platform.getOSArch())) {
            return false;
        }
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof WebBrowserEditorInput) {
            WebBrowserEditorInput wbei = (WebBrowserEditorInput)input;
            this.initialURL = null;
            if (wbei.getURL() != null) {
                this.initialURL = wbei.getURL().toExternalForm();
            }
            if (this.browser != null) {
                this.browser.setUrl(this.initialURL);
                site.getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
            }
            this.setPartName(wbei.getName());
            this.setTitleToolTip(wbei.getToolTipText());
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    protected abstract String getBaseURLPrefix();

    private synchronized void registerBrowserFunctions() {
        this.browserFunctions = new ArrayList<BrowserFunctionWrapper>();
        BrowserFunctionWrapper dispatcherFunction = this.browser.createBrowserFunction("dispatch", new DispatcherBrowserFunction());
        this.browserFunctions.add(dispatcherFunction);
        boolean executionResult = this.browser.execute("console = {}; console.log   = function(msg) {dispatch($H({controller:\"console\", action:\"log\", args:msg.toJSON()}).toJSON()); return false;};console.debug = function(msg) {dispatch($H({controller:\"console\", action:\"log\", args:msg.toJSON()}).toJSON()); return false;};");
        executionResult = this.browser.execute("function customErrorHandler(desc,page,line) { dispatch($H({controller:\"console\", action:\"error\", args:[desc,page,line].toJSON()}).toJSON());return false;};");
        executionResult = this.browser.execute("window.onerror=customErrorHandler;");
        if (!executionResult) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error registering the Portal browser functions", (Throwable)new IllegalStateException());
        }
    }

    private synchronized void refreshBrowserRegistration() {
        this.unregisterBrowserFunctions();
        String url = this.browser.getUrl();
        if (url != null && (url.startsWith(this.getBaseURLPrefix()) || url.startsWith("file:"))) {
            this.registerBrowserFunctions();
        }
    }

    private synchronized void unregisterBrowserFunctions() {
        if (this.browserFunctions != null) {
            for (BrowserFunctionWrapper bf : this.browserFunctions) {
                bf.dispose();
            }
            this.browserFunctions = null;
        }
    }

    private class PortalTitleListener
    implements TitleListener {
        private PortalTitleListener() {
        }

        public void changed(TitleEvent event) {
            AbstractPortalBrowserEditor.this.refreshBrowserRegistration();
        }
    }
}

